<?php
// generate-form.php

require_once __DIR__ . '/vendor/autoload.php';
use Dompdf\Dompdf;

require_once __DIR__ . '/db.php';
session_start();

// 1) Determine source table and ID
if (isset($_GET['pending'])) {
    $id    = (int)$_GET['pending'];
    $table = 'pending_exco';
} elseif (isset($_GET['user_id'])) {
    $id    = (int)$_GET['user_id'];
    $table = 'members';
} else {
    die('Invalid request');
}

// 2) Fetch the data
$stmt = $conn->prepare("
    SELECT full_name,
           staff_number AS NE,
           ic_number    AS no_kp,
           location     AS daerah,
           address,
           ack_date
      FROM `$table`
     WHERE id = ?
");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($full_name, $ne, $no_kp, $daerah, $address, $ack_date);
if (!$stmt->fetch()) {
    die('Record not found');
}
$stmt->close();

// 3) Format date using the acknowledgment timestamp
$date = date('d/m/Y', strtotime($ack_date));

// 4) Build the HTML
$html = '
<html>
<head>
  <meta charset="UTF-8">
  <style>
    body { font-family: Arial, sans-serif; font-size:10pt; margin:40px; }
    .title     { float:right; font-weight:bold; }
    .field     { clear:both; margin-bottom:6px; }
    .label     { display:inline-block; width:70px; }
    .sep       { display:inline-block; width:10px; }
    .input     { display:inline-block; border-bottom:1px dotted #000; width:350px; }
    .multiline { margin-left:80px; border-bottom:1px dotted #000; width:350px; height:18px; }
    .section   { margin-top:20px; }
    .paragraph { text-align:justify; margin-bottom:18px; line-height:1.2; }
    .signature { margin-top:60px; text-align:left; }
    .sig-line  { display:inline-block; width:200px; border-bottom:1px dotted #000; }
  </style>
</head>
<body>
  <div class="title">KPPSAJ 2</div>

  <div class="field">
    <span class="label">Nama</span><span class="sep">:</span>
    <span class="input">' . htmlspecialchars($full_name) . '</span>
  </div>
  <div class="field">
    <span class="label">NE</span><span class="sep">:</span>
    <span class="input">' . htmlspecialchars($ne) . '</span>
  </div>
  <div class="field">
    <span class="label">No K/P</span><span class="sep">:</span>
    <span class="input">' . htmlspecialchars($no_kp) . '</span>
  </div>
  <div class="field">
    <span class="label">Daerah</span><span class="sep">:</span>
    <span class="input">' . htmlspecialchars($daerah) . '</span>
  </div>

  <div class="field">
    <span class="label">Alamat</span><span class="sep">:</span>
  </div>';
// multi-line address
foreach (explode("\n", htmlspecialchars($address)) as $line) {
    $html .= '<div class="multiline">' . trim($line) . '</div>';
}
$html .= '
  <div class="field" style="margin-top:12px;">
    <span class="label">Tarikh</span><span class="sep">:</span>
    <span class="input">' . $date . '</span>
  </div>

  <div class="section">
    <strong>Kepada :-</strong><br><br>
    Presiden<br>
    Kesatuan Pekerja-Pekerja Ranhill SAJ Sdn Bhd<br>
    Bangunan Ranhill SAJ Sdn. Bhd.<br>
    Jalan Ibrahim,<br>
    84000 Muar, Johor
  </div>

  <div class="section">
    <strong>Melalui,</strong><br>
    Ketua Jabatan<br>
    Jabatan Sumber Manusia<br>
    Ranhill SAJ Sdn. Bhd.
  </div>

  <div class="section">
    <p class="paragraph"><strong><u>PERSETUJUAN MEMBENARKAN PEMOTONGAN GAJI BULANAN DAN PENGECUALIAN MENERIMA RESIT YURAN BULANAN KESATUAN PEKERJA-PEKERJA RANHILL SAJ SDN BHD.</u></strong></p>
    <p class="paragraph">
      Adalah dengan hormatnya merujuk kepada perkara di atas, dengan ini saya memberi persetujuan dan kebenaran pihak tuan membuat potongan gaji bulanan bagi tujuan pembayaran yuran bulanan saya sebagai ahli Kesatuan Pekerja-Pekerja Ranhill SAJ Sdn. Bhd.
    </p>
    <p class="paragraph">
      2. Saya juga memberi kebenaran dan persetujuan untuk dikecualikan daripada penerimaan resit yuran bulanan Kesatuan Pekerja-Pekerja Ranhill SAJ Sdn. Bhd. lanjutan daripada kebenaran pembayaran yuran bulanan Kesatuan melalui potongan gaji bulanan oleh majikan bagi pihak Kesatuan.
    </p>
    <p class="paragraph">
      3. Saya juga faham dan bersetuju bahawa Penyata Gaji yang diterima dianggap sebagai pengganti resit pembayaran yuran bulanan.
    </p>
    <p class="paragraph">
      Sekian untuk makluman tuan.
    </p>
  </div>
  <p>&nbsp;</p>
  <p>&nbsp;</p>
  <div class="signature">
    ' . htmlspecialchars($full_name) . '<br>
	<span class="sig-line"></span><br>
    (Tandatangan)
  </div>

</body>
</html>
';

// 5) Render & stream PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("borang_pengesahan_penolakan_gaji_{$id}.pdf", ["Attachment" => false]);
exit;
