<?php
session_start();
if (isset($_SESSION['user'])) {
    header("Location: dashboard.php");
    exit;
}

// Ambil & padam "flash"
$error = $_SESSION['flash_error'] ?? '';
unset($_SESSION['flash_error']);

$last  = $_SESSION['flash_last'] ?? '';
unset($_SESSION['flash_last']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>KPPRSAJ - Database Information System</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * { box-sizing: border-box; }

        body {
            margin: 0; padding: 0; font-family: Arial, sans-serif;
            background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)),
                        url('assets/img/background.jpg') no-repeat center center fixed;
            background-size: cover;
            display: flex; justify-content: center; align-items: center;
            height: 100vh;
        }

        .login-box {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.25);
            width: 320px; z-index: 2; text-align: center;
        }

        .logo { display: block; margin: 0 auto 10px; max-width: 80px; height: auto; }
        .system-name { font-size: 14px; color: #666; margin-bottom: 20px; }
        .lang-toggle { font-size: 13px; margin-bottom: 15px; }
        .lang-toggle a { color: #007bff; text-decoration: none; margin: 0 5px; }
        .lang-toggle a:hover { text-decoration: underline; }
        h2 { margin: 15px 0; }

        .form-group { position: relative; }
        input[type="text"], input[type="password"] {
            width: 100%; margin: 10px 0; padding: 10px 44px 10px 10px; /* ruang kanan utk ikon */
            border-radius: 6px; border: 1px solid #ddd; background-color: #fff9c4;
            transition: box-shadow 0.2s ease;
        }
        input:focus { outline: none; box-shadow: 0 0 5px #007bff88; }

        /* IKON MATA — kecil & absolute, TIDAK terpengaruh gaya butang submit */
        .toggle-password {
            position: absolute;
            right: 10px; top: 50%; transform: translateY(-50%);
            background: transparent;
            border: none;
            padding: 0;
            width: 28px; height: 28px;
            display: inline-flex; align-items: center; justify-content: center;
            cursor: pointer;
            color: #0d6efd;
        }
        .toggle-password:focus { outline: 2px solid rgba(13,110,253,.35); border-radius: 6px; }
        .toggle-password svg { width: 20px; height: 20px; pointer-events: none; }

        .row-links {
            display: flex; justify-content: space-between; align-items: center;
            font-size: 13px; margin: 6px 0 12px;
        }
        .row-links label { display: flex; align-items: center; gap: 6px; color: #333; }
        .row-links input[type="checkbox"] { margin: 0; }
        .row-links a { color: #007bff; text-decoration: none; }
        .row-links a:hover { text-decoration: underline; }

        /* GAYA BUTANG SUBMIT — targetkan spesifik [type=submit] supaya ikon mata tak terkesan */
        button[type="submit"] {
            width: 100%; padding: 10px; background: #007bff; color: white; border: none;
            border-radius: 8px; font-weight: bold; cursor: pointer; transition: background 0.3s ease;
        }
        button[type="submit"]:hover { background: #0056b3; }
        button[type="submit"][disabled] { opacity: 0.7; cursor: not-allowed; }

        .error {
            background: #fdecea; color: #c62828; border: 1px solid #f5c6cb;
            padding: 10px; border-radius: 6px; font-size: 0.9em; margin-bottom: 10px; text-align: left;
        }

        @media (max-width: 400px) { .login-box { width: 90%; padding: 20px; } }
    </style>
</head>
<body>
    <form class="login-box" method="post" action="auth.php" autocomplete="off" novalidate id="loginForm">
        <img src="assets/img/kpprsaj-logo.png" alt="KPPRSAJ Logo" class="logo">
        <div class="system-name">Database Information System</div>
       <!-- <div class="lang-toggle"><a href="#">EN</a> | <a href="#">BM</a></div> -->

        <h2>LOG MASUK</h2>

        <?php if ($error): ?>
            <div class="error" role="alert"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <div class="form-group">
            <input type="text" name="staff_number" placeholder="Staff Number" required
                   value="<?= htmlspecialchars($last) ?>" autofocus
                   inputmode="numeric" autocomplete="username" spellcheck="false" aria-label="Staff Number">
        </div>

        <div class="form-group">
            <input type="password" name="password" placeholder="Password" required
                   autocomplete="current-password" id="passwordField" aria-label="Password">
            <button type="button" class="toggle-password" aria-label="Show password" id="togglePwdBtn" tabindex="0">
                <!-- eye icon -->
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" aria-hidden="true">
                    <path d="M1 12s4-7 11-7 11 7 11 7-4 7-11 7-11-7-11-7Z" stroke-width="2"/>
                    <circle cx="12" cy="12" r="3" stroke-width="2"/>
                </svg>
            </button>
        </div>

        <div class="row-links">
			<a href="forgot-password.php">Lupa kata laluan?</a>
			<a href="register.php">Klik sini untuk pendaftaran</a>
		</div>


        <button type="submit" id="submitBtn">Log Masuk</button>
    </form>

    <script>
      // toggle show/hide password
      const pwd = document.getElementById('passwordField');
      const btn = document.getElementById('togglePwdBtn');
      btn.addEventListener('click', () => {
          const showing = pwd.type === 'text';
          pwd.type = showing ? 'password' : 'text';
          btn.setAttribute('aria-label', showing ? 'Show password' : 'Hide password');
      });

      // support toggle with keyboard (Enter/Space) for accessibility
      btn.addEventListener('keydown', (e) => {
        if (e.key === 'Enter' || e.key === ' ') {
          e.preventDefault();
          btn.click();
        }
      });

      // loading state on submit / Enter
      const form = document.getElementById('loginForm');
      const submitBtn = document.getElementById('submitBtn');
      form.addEventListener('submit', function() {
          submitBtn.disabled = true;
          submitBtn.textContent = 'Signing in...';
      });
      form.addEventListener('keydown', function(e){
          if (e.key === 'Enter') {
              submitBtn.disabled = true;
              submitBtn.textContent = 'Signing in...';
          }
      });
    </script>
</body>
</html>
