<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit;
}

$user = $_SESSION['user'];
$role = $user['role'] ?? 'member';

$displayName = $user['name'] ?? ($user['full_name'] ?? 'User');

$badgeMap = [
    'admin'  => '🛡️ Admin',
    'ajk'    => '✅ AJK',
    'exco'   => '⭐ EXCO',
    'member' => '👤 Member',
];
$badge = $badgeMap[$role] ?? '👤 Member';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>KPPRSAJ System</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; font-family: Arial, sans-serif; background: #f0f2f5; }

        .topbar {
            background: #007bff;
            color: white;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: fixed;
            top: 0;
            width: 100%;
            height: auto;
            z-index: 10;
            flex-wrap: wrap;
        }

        .sidebar {
            width: 220px;
            background: #ffffff;
            height: 100vh;
            position: fixed;
            top: 50px;
            left: 0;
            border-right: 1px solid #ddd;
            overflow-y: auto;
            padding-top: 10px;
        }

        .sidebar img { max-width: 80px; display: block; margin: 10px auto 5px; }

        .role-badge {
            font-weight: bold;
            font-size: 13px;
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }

        .sidebar a {
            display: block;
            padding: 12px 20px;
            color: #333;
            text-decoration: none;
            border-bottom: 1px solid #f1f1f1;
        }
        .sidebar a:hover { background: #f0f0f0; }

        .main { margin-left: 220px; padding: 80px 40px 40px; }

        .logout-btn {
            background: #dc3545;
            color: white;
            padding: 6px 12px;
            border-radius: 5px;
            text-decoration: none;
            font-size: 14px;
            white-space: nowrap;
        }
        .logout-btn:hover { background: #b02a37; }

        .user-info { display: flex; align-items: center; gap: 10px; flex-wrap: wrap; }

        .sidebar-group { margin-top: 10px; }

        .sidebar-dropdown {
            padding: 10px 16px;
            cursor: pointer;
            font-weight: bold;
            user-select: none;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .sidebar-submenu {
            display: none;
            flex-direction: column;
            background: #f8f9fa;
            padding-left: 0;
        }

        .sidebar-submenu a {
            padding: 8px 20px;
            display: block;
            color: #333;
            text-decoration: none;
            border-bottom: 1px solid #eee;
        }
        .sidebar-submenu a:hover { background-color: #e9ecef; }

        @media screen and (max-width: 768px) {
            .main { margin-left: 0; padding: 100px 20px 20px; }
            .sidebar { position: static; width: 100%; height: auto; border-right: none; border-bottom: 1px solid #ddd; }
            .topbar { flex-direction: column; align-items: flex-start; }
        }
    </style>
</head>
<body>

<div class="topbar">
    <span><strong>KPPRSAJ Database Information System</strong></span>
    <div class="user-info">
        Logged in as: <?= htmlspecialchars($displayName) ?> |
        <a class="logout-btn" href="logout.php">Logout</a>
    </div>
</div>

<div class="sidebar">
    <img src="assets/img/kpprsaj-logo.png" alt="KPPRSAJ Logo">
    <div class="role-badge"><?= htmlspecialchars($badge) ?></div>

    <a href="dashboard.php">🏠 Dashboard</a>
    <a href="profile.php">👤 My Profile</a>

    <?php if (in_array($role, ['exco', 'ajk', 'admin'], true)): ?>
        <a href="approval.php">📝 Approval</a>
    <?php endif; ?>

    <?php if ($role === 'admin'): ?>
        <div class="sidebar-group">
            <div class="sidebar-dropdown" onclick="toggleSettingsMenu()">
                ⚙️ Settings <span id="settings-arrow">▼</span>
            </div>
            <div id="settings-submenu" class="sidebar-submenu">
                <a href="user-management.php">👥 User Management</a>
                <a href="settings-location.php">📍 Location Setup</a>
                <a href="settings-job-titles.php">👤 Job Titles Setup</a>
                <a href="settings-rejection-reasons.php">👤 Rejection Reasons</a>
                <a href="settings-deactivate-reasons.php">🔒 Deactivate Reasons</a>
                <a href="settings-payment.php">💳 Payment Information</a>
                <a href="password-reset-center.php">🔒 Password Center</a>
                <a href="settings-announcement.php">🔔 Announcement</a>
                <a href="meeting-settings.php">🔔 Meeting Settings</a>
            </div>

            <div class="sidebar-dropdown" onclick="toggleReportingMenu()">
                📊 Reporting <span id="reporting-arrow">▼</span>
            </div>
            <div id="reporting-submenu" class="sidebar-submenu">
                <a href="report_race_gender.php">📑 Membership Reports</a>
                <a href="approval-history.php">🕓 Approval History</a>
                <a href="report-active-users.php">📑 Active Users</a>
                <a href="report-inactive-users.php">📑 Inactive Users</a>
            </div>
        </div>
    <?php endif; ?>
</div>

<div class="main">
    <?= isset($content) ? $content : '' ?>
</div>

<script>
function toggleSettingsMenu() {
    const submenu = document.getElementById("settings-submenu");
    const arrow = document.getElementById("settings-arrow");
    if (!submenu || !arrow) return;

    if (submenu.style.display === "flex") {
        submenu.style.display = "none";
        arrow.textContent = "▼";
    } else {
        submenu.style.display = "flex";
        arrow.textContent = "▲";
    }
}

function toggleReportingMenu() {
    const submenu = document.getElementById("reporting-submenu");
    const arrow = document.getElementById("reporting-arrow");
    if (!submenu || !arrow) return;

    if (submenu.style.display === "flex") {
        submenu.style.display = "none";
        arrow.textContent = "▼";
    } else {
        submenu.style.display = "flex";
        arrow.textContent = "▲";
    }
}

window.addEventListener('DOMContentLoaded', () => {
    const page = window.location.pathname;

    if (page.includes("user-management") || page.includes("settings-location")) {
        const sm = document.getElementById("settings-submenu");
        const sa = document.getElementById("settings-arrow");
        if (sm) sm.style.display = "flex";
        if (sa) sa.textContent = "▲";
    }

    <?php if (isset($_SESSION['flash'])): ?>
    Swal.fire({
        icon: '<?= $_SESSION['flash']['type'] ?>',
        title: '<?= addslashes($_SESSION['flash']['message']) ?>',
        showConfirmButton: false,
        timer: 2500
    });
    <?php unset($_SESSION['flash']); endif; ?>
});
</script>

</body>
</html>
