<?php
session_start();
require_once "db.php";

/**
 * register-success.php
 * --------------------
 * Papar mesej kejayaan selepas pendaftaran / persetujuan gaji.
 */

$pending_id = $_SESSION['pending_id'] ?? null;
$flash = $_SESSION['flash'] ?? null;
if ($flash) unset($_SESSION['flash']);

// Dapatkan nama pemohon
$applicant_name = null;
if ($pending_id) {
    if ($stmt = $conn->prepare("SELECT full_name FROM pending_exco WHERE id=? LIMIT 1")) {
        $stmt->bind_param("i", $pending_id);
        $stmt->execute();
        $stmt->bind_result($applicant_name);
        $stmt->fetch();
        $stmt->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="ms">
<head>
<meta charset="UTF-8">
<title>Pendaftaran Berjaya - KPPRSAJ</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body {
  font-family: "Segoe UI", Arial, sans-serif;
  background: linear-gradient(rgba(0,0,0,0.6), rgba(0,0,0,0.6)),
              url('assets/img/background.jpg') no-repeat center center fixed;
  background-size: cover;
  display: flex;
  justify-content: center;
  align-items: center;
  min-height: 100vh;
  margin: 0;
  color: #222;
}

.success-box {
  background: #fff;
  padding: 36px 30px;
  border-radius: 14px;
  box-shadow: 0 10px 30px rgba(0,0,0,0.25);
  text-align: center;
  max-width: 520px;
  width: 92%;
  animation: fadeIn 0.6s ease-out;
}

.success-box h2 {
  margin-top: 0;
  color: #198754;
  font-size: 1.7rem;
}

.success-box p {
  margin: 10px 0 22px;
  color: #333;
  line-height: 1.5;
}

.success-box .highlight {
  background: #e7f5ee;
  border: 1px solid #b7e4c7;
  color: #166534;
  padding: 10px 14px;
  border-radius: 10px;
  font-size: 0.95rem;
  margin-bottom: 20px;
  text-align: left;
}

.success-box a.btn {
  display: inline-block;
  padding: 10px 22px;
  background: #007bff;
  color: #fff;
  border-radius: 8px;
  text-decoration: none;
  font-weight: 600;
  transition: background .2s ease;
}
.success-box a.btn:hover {
  background: #0056b3;
}

/* Butang sekunder (Kembali ke Log Masuk) */
.success-box a.btn-secondary {
  display: inline-block;
  padding: 10px 22px;
  background: #6c757d;
  color: #fff;
  border-radius: 8px;
  text-decoration: none;
  font-weight: 600;
  transition: background .2s ease;
  margin-top: 12px;
}
.success-box a.btn-secondary:hover {
  background: #5a6268;
}

@keyframes fadeIn {
  from { opacity: 0; transform: translateY(15px); }
  to { opacity: 1; transform: translateY(0); }
}

.muted{ color:#555; font-size: .95rem; }
</style>
</head>
<body>
<div class="success-box">
  <h2>🎉 Pendaftaran Telah Berjaya</h2>

  <?php if ($applicant_name && $pending_id): ?>
    <div class="highlight">
      <div><strong>Nama Pemohon:</strong> <?= htmlspecialchars($applicant_name, ENT_QUOTES, 'UTF-8'); ?></div>
      <div><strong>ID Permohonan:</strong> #<?= (int)$pending_id; ?></div>
    </div>
  <?php endif; ?>

  <p class="muted">
    <?php if ($flash && isset($flash['type']) && $flash['type'] === 'success'): ?>
      <?= htmlspecialchars((string)$flash['message'], ENT_QUOTES, 'UTF-8'); ?>
    <?php elseif ($applicant_name && $pending_id): ?>
      Pendaftaran anda telah dihantar dan menunggu <strong>kelulusan EXCO</strong>.
      Anda boleh log masuk selepas permohonan disahkan.
    <?php else: ?>
      Pendaftaran / persetujuan anda telah diproses. Jika anda baru mendaftar,
      sila semak status melalui slip permohonan atau hubungi pentadbir.
    <?php endif; ?>
  </p>

  <?php if ($pending_id): ?>
    <a href="slip-permohonan.php?id=<?= (int)$pending_id; ?>" class="btn">Lihat Slip Permohonan</a><br>
  <?php endif; ?>

  <a href="index.php" class="btn-secondary">← Kembali ke Log Masuk</a>
</div>
</body>
</html>
