<?php
// slip-permohonan-pdf.php
require_once 'db.php';
require_once 'vendor/autoload.php';
use Dompdf\Dompdf;

// Validate
if (!isset($_GET['id'])) {
    die('ID tidak sah.');
}
$id = (int)$_GET['id'];

// Helper to fetch application row from a table
function fetch_application(mysqli $conn, string $table, int $id): ?array {
    $sql = "
        SELECT
          full_name, staff_number, ic_number, email, job_title, home_phone, phone, race, location,
          address, postcode, created_at, waris_name, waris_phone
        FROM `$table`
        WHERE id = ?
        LIMIT 1
    ";
    if (!$stmt = $conn->prepare($sql)) return null;
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res ? $res->fetch_assoc() : null;
    $stmt->close();
    return $row ?: null;
}

// 1) Try pending_exco
$source = 'pending_exco';
$row = fetch_application($conn, $source, $id);

// 2) Fallback to pending_ajk if not found
if (!$row) {
    $source = 'pending_ajk';
    $row = fetch_application($conn, $source, $id);
}

// 3) If still not found, stop
if (!$row) {
    die('Rekod tidak ditemui.');
}

$stage_label = ($source === 'pending_ajk') ? 'AJK' : 'EXCO';

// Escape all output
$e = fn($v) => htmlspecialchars((string)($v ?? ''), ENT_QUOTES, 'UTF-8');

$full_name   = $e($row['full_name']);
$staff_no    = $e($row['staff_number']);
$ic_no       = $e($row['ic_number']);
$email       = $e($row['email']);
$job_title   = $e($row['job_title'] ?? '-');
$home_phone  = $e($row['home_phone'] ?? '-');
$phone       = $e($row['phone']);
$race        = $e($row['race']);
$location    = $e($row['location']);
$address     = $e($row['address'] ?? '-');
$postcode    = $e($row['postcode'] ?? '-');
$created_at  = $e($row['created_at']);
$waris_name  = $e($row['waris_name'] ?? '-');
$waris_phone = $e($row['waris_phone'] ?? '-');

// Build HTML
$html = <<<HTML
<html>
<head>
  <meta charset="UTF-8">
  <style>
    body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
    h1 { text-align: center; margin: 0 0 6px; }
    .stage { text-align:center; color:#555; margin-bottom: 12px; }
    table { width: 100%; border-collapse: collapse; margin-top: 6px; }
    th, td { border: 1px solid #333; padding: 6px 8px; vertical-align: top; }
    th { background: #eee; width: 34%; }
    .note { border:1px dashed #000; padding:10px; font-size:12px; background-color:#f9f9f9; margin-top:12px; }
  </style>
</head>
<body>
  <h1>Slip Permohonan KPPRSAJ</h1>
  <div class="stage">Peringkat Semasa: <strong>{$e($stage_label)}</strong></div>

  <table>
    <tr><th>Nama Penuh</th><td>{$full_name}</td></tr>
    <tr><th>No. Anggota</th><td>{$staff_no}</td></tr>
    <tr><th>No. KP</th><td>{$ic_no}</td></tr>
    <tr><th>Email</th><td>{$email}</td></tr>
    <tr><th>Jawatan</th><td>{$job_title}</td></tr>
    <tr><th>No. Tel Kediaman</th><td>{$home_phone}</td></tr>
    <tr><th>No. Tel Bimbit</th><td>{$phone}</td></tr>
    <tr><th>Bangsa</th><td>{$race}</td></tr>
    <tr><th>Lokasi Bertugas</th><td>{$location}</td></tr>
    <tr><th>Alamat Kediaman</th><td>{$address}</td></tr>
    <tr><th>Poskod</th><td>{$postcode}</td></tr>

    <tr><th>Nama Waris</th><td>{$waris_name}</td></tr>
    <tr><th>No. Telefon Waris</th><td>{$waris_phone}</td></tr>

    <tr><th>Tarikh Permohonan</th><td>{$created_at}</td></tr>
  </table>

  <div class="note">
    <strong>Peringatan:</strong><br>
    Permohonan ini masih tertakluk kepada kelulusan Mesyuarat EXCO dan AJK.<br>
    Pemohon hanya akan dianggap sebagai ahli rasmi setelah permohonan diluluskan sepenuhnya.
  </div>
</body>
</html>
HTML;

// Generate PDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Attachment=1 untuk force download; =0 untuk inline
$download = isset($_GET['download']) ? 1 : 0;
$dompdf->stream("Slip_Permohonan_{$id}.pdf", ["Attachment" => $download]);
exit;
