<?php
/**
 * db.php — KPPRSAJ DIS
 * - Sambungan MySQLi (utf8mb4, TZ +08:00)
 * - TIADA APP_KEY diperlukan
 * - dis_crypto_key(): derive kunci AES-256-GCM dari config DB (host|user|password|dbname)
 */

$host     = getenv('DIS_DB_HOST')     ?: 'localhost';
$user     = getenv('DIS_DB_USER')     ?: 'dis';
$password = getenv('DIS_DB_PASSWORD') ?: 'P@ssw0rd1234';
$dbname   = getenv('DIS_DB_NAME')     ?: 'dis';

$conn = new mysqli($host, $user, $password, $dbname);
if ($conn->connect_error) {
    error_log('DB connect error: ' . $conn->connect_error);
    die('Connection failed.');
}
@$conn->set_charset('utf8mb4');
@$conn->query("SET time_zone = '+08:00'");

/**
 * Kunci kripto 32-byte untuk AES-256-GCM.
 * Tidak perlukan .env — kita derive dari parameter DB yang sudah ada.
 * Nota: menukar credential DB akan menukar kunci ➜ record lama tak boleh reveal lagi.
 */
if (!function_exists('dis_crypto_key')) {
    function dis_crypto_key(): string {
        // Gabung material yang memang dah ada dalam file ini
        $material = ($GLOBALS['host'] ?? '') . '|' .
                    ($GLOBALS['user'] ?? '') . '|' .
                    ($GLOBALS['password'] ?? '') . '|' .
                    ($GLOBALS['dbname'] ?? '') . '|dis-reset-v1';
        // HKDF jika ada, fallback ke SHA-256 binary
        if (function_exists('hash_hkdf')) {
            return hash_hkdf('sha256', $material, 32, 'kpprsaj-dis', 'v1');
        }
        return hash('sha256', $material, true); // 32 bytes (binary)
    }
}

/**
 * Optional: audit helper (no-op jika jadual audit_logs tiada)
 */
if (!function_exists('write_audit')) {
    function write_audit(mysqli $conn, ?int $actorId, ?int $subjectId, string $action, $meta = null): bool {
        $metaStr = is_null($meta) ? null : (is_string($meta) ? $meta : json_encode($meta, JSON_UNESCAPED_UNICODE));
        $sql = "INSERT INTO audit_logs (actor_id, subject_id, action, meta, created_at)
                VALUES (?, ?, ?, ?, NOW())";
        $stmt = @$conn->prepare($sql);
        if (!$stmt) return false;
        $a = $actorId ?? null; $s = $subjectId ?? null;
        $stmt->bind_param("iiss", $a, $s, $action, $metaStr);
        @$stmt->execute();
        @$stmt->close();
        return true;
    }
}
